var API_URL = "https://signageapi.mirajcinemas.com";

var deviceLabel = document.getElementById("deviceId");
var device = {},
  downloadedFiles = {},
  duration = 0;

function getDetails(type) {
  try {
    var value = localStorage.getItem(type);
    if (!!value) return JSON.parse(localStorage.getItem(type));
    else {
      if (type === "device") return {};
      else if (type === "download") return [];
    }
  } catch (e) {
    console.log("JSON parse failed");
  }
}

function setDetails(type, value) {
  localStorage.setItem(type, JSON.stringify(value));
  if (type === "device") device = value;
  else if (type === "download") downloadedFiles = value;
}

function getDeviceDetails() {
  return getDetails("device");
}

function getDownloadDetails() {
  return getDetails("download");
}

function register() {
  var xhr = new XMLHttpRequest();
  var url = API_URL + "/device/register/web";

  xhr.open("POST", url, true);
  xhr.setRequestHeader("Content-Type", "application/json");

  xhr.onreadystatechange = function () {
    if (xhr.readyState === 4) {
      if (xhr.status === 201) {
        var response = JSON.parse(xhr.responseText);
        setDetails("device", response.data);
        updateDeviceId();
      } else {
        console.log("Error registering device");
      }
    }
  };

  xhr.send();
}

function updateDownloads(content) {
  setDetails("download", content);
  sendToDevices(content, false);
  updateDuration();
}

function updateDuration() {
  var downloads = getDownloadDetails();
  if (Array.isArray(downloads) && downloads.length > 0)
    duration = downloads
      .map(function (d) {
        return d.duration;
      })
      .reduce(function (a, b) {
        return a + b;
      });
}

function checkDeviceDetails() {
  var xhr = new XMLHttpRequest();
  var url = API_URL + "/device/code/" + device.deviceId;

  xhr.open("GET", url, true);

  xhr.onreadystatechange = function () {
    if (xhr.readyState === 4) {
      if (xhr.status === 200) {
        var response = JSON.parse(xhr.responseText);
        setDetails("device", response);
        updateDeviceId();
      } else {
        console.log("Error getting latest device details");
      }
    }
  };

  xhr.send();
}

var body = document.getElementById("body");
var container = document.getElementById("container");
var timeoutVar,
  i = 0;

function clearContainer(isSyncing) {
  console.log("clearing container", isSyncing);
  // container.innerHTML = "";

  var videoElement = document.querySelectorAll("video");
  if (videoElement.length > 0)
    videoElement.forEach(function (el) {
      el.pause();
      if (!isSyncing) {
        el.removeAttribute("src");
        el.load();
      }
    });

  if (!isSyncing) {
    var imageElement = document.querySelectorAll("img");
    if (imageElement.length > 0)
      imageElement.forEach(function (el) {
        // badImage.parentElement.removeChild(badImage);
        el.parentElement.removeChild(el);
      });
    container.remove();
    container = document.createElement("div");
    container.id = "container";
    body.appendChild(container);
  }
  if (timeoutVar) {
    console.log("clearing timeout overall", timeoutVar);
    clearTimeout(timeoutVar);
  }
}

function showWhatsNeeded(content, allElements) {
  // console.log("showing whats needed", content.path);
  // console.log(container);
  allElements.forEach(function (el) {
    if (el) {
      el.style.height = 0;
      el.style.opacity = 0;
    }
  });
  var element = document.getElementById(content.path);
  if (element) {
    if (element.nodeName === "VIDEO") element.currentTime = 0;
    element.style.height = "100vh";
    element.style.width = "100vw";
    element.style.opacity = 100;
    if (element.nodeName === "VIDEO") element.play();
  }
}

function sendToDevices(content, isSyncing) {
  if (Array.isArray(content) && content.length > 0) {
    // console.log({ content });
    clearContainer(isSyncing);
    var ids = content.map(function (c) {
      return c.path;
    });
    i = 0;
    if (!isSyncing)
      content.forEach(function (c) {
        if (c.type === "image") {
          var image = document.createElement("img");
          // image.src = c.path;
          image.src = c.path;
          // console.log(image.src);
          image.id = c.path;
          image.alt = "content-image";
          image.style.opacity = 0;
          image.style.position = "absolute";
          image.style.top = "0";
          // image.style.objectFit = "contain";
          image.style.height = 0;
          image.addEventListener("load", function () {
            // console.log("image loaded completely");
            container.appendChild(image);
          });
          // container.appendChild(image);
        } else if (c.type === "video") {
          var video = document.createElement("video");
          video.src = c.path;
          video.id = c.path;
          video.autoplay = false;
          video.muted = true;
          // video.controls = true;
          video.currentTime = 0;
          video.pause();
          video.addEventListener("ended", function (e) {
            e.currentTarget.pause();
            e.currentTarget.currentTime = 0;
            i++;
            if (i === content.length) {
              console.log(
                "triggering an infinite loop from video",
                i,
                content.length
              );
              i = 0;
            }
            console.log("i is now", i);
            myLoop();
            console.log("video playback completed: value of i now", i);
          });
          video.style.opacity = 0;
          video.style.height = 0;
          video.style.position = "absolute";
          video.style.top = "0";
          // video.style.objectFit = "contain";
          container.appendChild(video);
        } else if (c.type === "html") {
          var iframe = document.createElement("iframe");
          iframe.src = c.path + "?" + c.param;
          iframe.id = c.path;
          iframe.style.opacity = 0;
          iframe.style.height = 0;
          iframe.style.background = "white";
          iframe.style.position = "absolute";
          iframe.style.top = "0";
          container.appendChild(iframe);
        }
      });

    function myLoop() {
      // console.log("in my loop", i);
      var allElements = ids.map(function (id) {
        return document.getElementById(id);
      });
      showWhatsNeeded(content[i], allElements);

      // console.log("content type is not video", content[i].duration);
      if (content[i].type === "video") {
        // console.log("type video in loop, clearing timeout", timeoutVar);
        clearTimeout(timeoutVar);
      } else {
        timeoutVar = setTimeout(function () {
          i++;
          if (i < content.length) {
            // console.log("clearing timeout", timeoutVar);
            clearTimeout(timeoutVar);
          } else {
            // console.log("myloop: triggering an infinite loop");
            i = 0; // for infinite loop
          }
          myLoop();
        }, content[i].duration * 1000);
        // console.log("timeout variable created");
      }
      // console.log("myloop timeoutvar id", timeoutVar);
    }

    myLoop();
  } else {
    console.log("blank content received");
    clearContainer(false);
  }
}

function showDeviceId() {
  deviceLabel.style.display = "block";
  setTimeout(function () {
    deviceLabel.style.display = "none";
  }, 10000);
}

function updateDeviceId() {
  deviceLabel.innerHTML = device.deviceId + "<br/>" + device.name;
  showDeviceId();
}

function fetchCommands() {
  var xhr = new XMLHttpRequest();
  var url = API_URL + "/device/everything/about/me/web/" + device.deviceId;

  xhr.open("GET", url, true);

  xhr.onreadystatechange = function () {
    if (xhr.readyState == 4) {
      if (xhr.status == 200) {
        try {
          var response = JSON.parse(xhr.responseText);
          var command = response.command;
          var value = response.value;

          switch (command) {
            case "appreboot":
              window.location.reload();
              break;
            case "showDeviceId":
              showDeviceId();
              break;
            case "content":
              try {
                var content = JSON.parse(value);
                updateDownloads(content);
              } catch (e) {
                updateDownloads([]);
              }
              break;
            case "updateDevice":
              checkDeviceDetails();
              break;
            default:
              console.log("nothing can be done.");
          }
        } catch (e) {
          // console.log("Error parsing JSON response");
        }
      } else {
        // console.log("Error fetching everything about me");
      }
    }
  };

  xhr.send();
}

function main() {
  device = getDeviceDetails();
  if (!device || Object.keys(device).length === 0) {
    console.log("registering");
    device = register();
  } else {
    updateDeviceId();
  }

  setInterval(function () {
    fetchCommands();
  }, 5000);
  downloadedFiles = getDownloadDetails();
  if (Array.isArray(downloadedFiles) && downloadedFiles.length > 0) {
    sendToDevices(downloadedFiles, false);
  }
}
main();
