import redis
import time
import subprocess
import json
import os
import wget
import hashlib
import requests
import glob
import sys
import math

mainpath = "/cache-files/"
cnfrmapi = "https://api-play.enpointe.io/ffmpeg/local-cache"
cinemaname = "playjeddah"

try:
    r = redis.Redis(
        host='play.enpointe.io',
        port=6379,
        password='g4QLiT2ELqs3986P2e8xQYGRZlbLKjYMj5qYP7r1dq+TtjodCyV+r1YZYZE8TWx0hmDU7+qROeLsqSNq',
        # username="admin",
        decode_responses=True,
        health_check_interval=25,
        socket_connect_timeout=5,
        socket_timeout=5
    )
except Exception as e:
    print("REDIS INIT ERROR:", e)
    sys.exit(1)

def progressBar(current, total, width=80):
    dlpercent = math.ceil(current / total * 100)
    print(f"Downloading: {dlpercent}%")

def downloadFile(url, location=""):
    filepath = f'/cache-files/{url.split("/")[-1]}'
    if os.path.isfile(filepath):
        print("File already exists:", filepath)
        return filepath

    for attempt in range(10):
        try:
            print(f"Attempt {attempt + 1}: Downloading {url}")
            wget.download(url, out=filepath, bar=progressBar)
            print("Downloaded successfully:", filepath)
            return filepath
        except Exception as e:
            print("Download error:", e)
            time.sleep(1)
    print("Download failed after 10 attempts")
    return None

def sendcomplete(url, data):
    headers = {'Content-Type': 'application/json'}
    try:
        response = requests.post(url, data=data, headers=headers, timeout=10)
        return response
    except requests.exceptions.RequestException as e:
        print("Error sending completion:", e)
        return None

def get_ip():
    try:
        ip = subprocess.check_output(['hostname', '--all-ip-addresses'], timeout=3)
        return ip.decode(sys.stdout.encoding).strip().replace(" ", "")
    except Exception as e:
        print("Failed to get IP address:", e)
        return "127.0.0.1"

while True:
    time.sleep(0.1)

    try:
        r.set(f"{cinemaname}-cache-online", "True", ex=100)
    except Exception as e:
        print("Redis SET error:", e)
        os.system("systemctl restart caching.service")
        continue

    try:
        queue_data = r.lpop(f"{cinemaname}-cache-queue")
    except Exception as e:
        print("Redis LPOP error:", e)
        os.system("systemctl restart caching.service")
        continue

    if not queue_data:
        continue

    print("\n:::: PROCESS STARTING ::::\n")

    try:
        queue = json.loads(queue_data)
    except json.JSONDecodeError as e:
        print("JSON decode error:", e)
        continue

    deviceID = queue.get("deviceId")
    jobID = queue.get("jobId")
    content = queue.get("content")

    if not deviceID or not jobID:
        print("Missing deviceId or jobId in queue item.")
        continue

    if content and content != "[]" and isinstance(content, list):
        ipaddress = get_ip()
        for n, files in enumerate(content):
            filepath = os.path.basename(files['path'])
            dlink = files["path"].replace(filepath, "")
            filepath = mainpath + filepath

            if not os.path.exists(filepath):
                print("File not found, downloading:", filepath)
                actual_link = files["path"]
                if files["type"] in ("video", "image"):
                    actual_link = actual_link.replace("https://ffmpeg.videostation.tech", "http://ffmpeg.rev.vet:8080")

                downloaded = downloadFile(actual_link.split("?")[0])
                if not downloaded:
                    print("Skipping file due to download failure.")
                    continue

            local_path = f"http://{ipaddress}:4001/{filepath.replace(mainpath, '')}"
            content[n]['localPath'] = local_path

            if deviceID == "6329-IM6IZG":
                content[n]['path'] = local_path

        queue['content'] = content
        queue['cached'] = True
        result = sendcomplete(cnfrmapi, json.dumps(queue))
        print("Server response:", result.text if result else "No response")

    elif content == "[]":
        queue['cached'] = True
        result = sendcomplete(cnfrmapi, json.dumps(queue))
        print("Server response for blank content:", result.text if result else "No response")

    else:
        print("Malformed content in queue:", content)
